-- Helper Functions for CAT macroscripts

-----------------------------------------------------------------------------------------------
-- function: GetCATNodeGroup
-- Does: Finds the group (data) controller of the passed node, if it exists
-- Arguments: aNode a node to search.
-- Returns: The group controller of the node.
-----------------------------------------------------------------------------------------------	
fn GetCATNodeGroup aNode = 
(
	local catctrl = aNode.controller
	
	catctrl = case (classof catctrl) of
	(
		CATBoneSegTrans:	( catctrl = catctrl.bonedata.limb; )
		CollarboneTrans:		( catctrl = catctrl.Limb; )
		CATDigitSegTrans:	( catctrl = catctrl.digitdata.controller; )
		TailTrans:		( catctrl = catctrl.taildata;  )
		default:			( catctrl; )
	)
	
	catctrl;
)

-----------------------------------------------------------------------------------------------
-- function: GetCatParent 	
-- Does: Finds the CATParent of passed node or controller, if it is part of a CAT character
-- Arguments: aNodeOrController Either a node or controller to search.
-- Returns: CATparent found, or undefined if not a member of a CAT character
-----------------------------------------------------------------------------------------------	
fn GetCATParent aNodeOrController = 
(
	res = undefined;
	ctrl = aNodeOrController;
	if (iskindof aNodeOrController Node) then ctrl = aNodeOrController.controller

	if (ctrl != undefined) then (
		if ((GetInterface ctrl "ICATControlFPInterface") != undefined) then (res = ctrl.catparent)
		else if (classof ctrl == CATParentTrans) do (res = ctrl.node.baseobject)
	)
	res;
)

function GetSelectedSubAnim subAnimIndex = 
(
	result = undefined
	if selection.count == 1 then 
	(
		local selObj = selection[1]
		if (selObj.numSubs >= subAnimIndex) then
		(
			result = GetSubAnim selObj subAnimIndex
		)
	)
	result
)

function GetSelectedCATParent = 
(
	result = undefined
	local selSubAnim = GetSelectedSubAnim 3
	if (selSubAnim != undefined) then
	(
		result = GetCATParent selSubAnim;
	)
	result
)
function SelectionHasCATParent = 
(
	result = false
	local cparent = GetSelectedCATParent()
	if (cparent != undefined) then
	(
		result = true
	)
	result
)

function CATParentSetupMode = 
(
	result = false
	local selCatParent = GetSelectedCATParent()
	if (selCatParent != undefined) then
	(
		if( selCatParent.catmode == 0 ) then 
			result = true;
	)
	result
)

function IsSelectionSubAnimClassOf classType = 
(
	result = false
	if selection.count == 1 then 
	(
		local selObj = selection[1]
		if (selObj.numSubs >= 3) then
		(
			local selSubAnim = GetSubAnim selObj 3
			if (selSubAnim != undefined) then
			(
				if (hasproperty selSubAnim "CatParent") then
				(
					if(classof selSubAnim.controller) == classType then 
						result = true;
				)
			)
		)
	)
	result
)

function DoesSelectedContainInterface interfaceName = 
(
	local result = false
	for obj in selection while result == false do
	(
		if (getinterface obj[3] interfaceName) != undefined then
		(
			result = true;
		)
	)
	result	
)

function IsFloatController v = 
(
	isValid = (isProperty v.anim #value) and (classof v.anim.value == Float) and (isPropertyAnimatable v.client v.name)
	isValid
)

function IsCATEntity v = ( res = (GetCATParent v != undefined); res )

-- Global shut down utility function for CAT
function CAT_OnMaxShutdown =
(
	unregisterSelectFilterCallback IsCATEntity
	unregisterDisplayFilterCallback IsCATEntity
	callbacks.RemoveScripts id: #CATUtils
)

-- Global startup utility function for CAT
function CAT_OnMaxStartup = 
(
	-- Register a display filter to display only CATEntities
	registerSelectFilterCallback IsCATEntity ~SELECT_FILTER_CALL_CATENTITY_NAME~
	registerDisplayFilterCallback IsCATEntity ~DISPLAY_FILTER_CALL_CATENTITY_NAME~
	-- Failing to unregister these callbacks will result in a memory leak. Thus we have to register a callback to do that
	-- when max quits
	callbacks.RemoveScripts id: #CATUtils -- Attempt to remove the old one if the script is re-evaluated
	callbacks.AddScript #preSystemShutdown "CAT_OnMaxShutdown()" id: #CATUtils
)
CAT_OnMaxStartup();
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAX4288oOlf7mA6jWi+/CXF3oEvKnLxnXfr
-- nrVk37QIUUBkqsghSwtloNM1lxuTLupuz3TObxkhR3j7Y8Qrlu9DiP5PDyKGy0eM
-- yqBn/JRzBC4XsTNngd3B8wUO83NsSlQf3GPH4u2P9dqtrVEcjAkdHVRKDqaZ3aU9
-- xIOE7KczJTZJrXSykUjLGi1YHxNOkrOjQAhaevHW3dn+Tb6RCsMyYef0wUY6WAaQ
-- PvStRYlkB6WwCzdRxEJoPSW+hkVooyAOzi9LyivNtveGgGPMVYSLdVv/eTm9pTQH
-- Yi6egisK7FtAdAxeZIQQvSpWSr9nkpF4SNFPVTDdHK5CzjSDtjiL
-- -----END-SIGNATURE-----